 ; Ŀ
 ;   Fint - find and optionally erase entities by insertion point.         
 ;   Subentities are deleted by killing the entire complex entity.         
 ;   If the entities aren't erased they become the Previous set.           
 ;   Copyright 1995, 1998, 2006, 2007 by Rocket Software Ltd.              
 ;   Neolithic cultures built with stone and did not wear clothing.        
 ;   Was this an attempt to avoid producing lint?                          
 ; 
         
 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Headup - returns the ename of the head entity belonging to a          
 ;   subentity whose ename is passed as the sole argument.                 
 ; 
 (DEFUN HEADUP (enam /)
  (while (/= (cdr (assoc 0 (entget (setq enam (entnext enam))))) "SEQEND"))
 (cdr (assoc -2 (entget enam))))
 ; Ŀ
 ;   Headup end.                                                           
 ; 

 ; Ŀ
 ;   Finto - hidden original version - find entities by insertion point.   
 ;   The elegance of the solution doesn't hide the stupidity of the        
 ;   problem.                                                              
 ; 
 (DEFUN C:FINTO (/ pa fuzz entt)
  (setvar "cmdecho" 0)
  (setq pa (getpoint "Insertion to locate: "))
  (setq fuzz (getdist "Slop allowance <0.1>: "))
  (if (null fuzz) (setq fuzz 0.1))
  (setq enam (entnext))
  (if (equal pa (cdr (assoc 10 (setq entt (entget enam)))) fuzz)
      (print entt))
  (while (setq enam (entnext enam))
         (if (equal pa (cdr (assoc 10 (setq entt (entget enam)))) fuzz)
             (print entt)))
 (princ))
 ; Ŀ
 ;   C:Finto end.                                                          
 ; 

 ; Ŀ
 ;   Fint.                                                                 
 ; 
 (DEFUN C:FINT (/ rad kill kills pa fuzz entt enam ten llist inner num sub len)
  (setvar "cmdecho" 0)
  (setq rad (/ (getvar "viewsize") 25))
 ; Ŀ
 ;   Get insertion to find and fuzz factor.                                
 ; 
  (setq pa (getpoint "Insertion to locate: "))
  (setq fuzz (getdist pa "Slop allowance <0.1>: "))
  (if (null fuzz) (setq fuzz 0.1))
 ; Ŀ
 ;   Ask whether to kill located entities.                                 
 ; 
  (initget 0 "Yes No")
  (Setq kill (getkword "\nKill entities? <N>: "))
  (if (or (null kill) (= kill "No"))
      (setq kill ())
      (setq kill t))
 ; Ŀ
 ;   Initialize an empty ss.                                               
 ; 
  (setq ss (ssadd))
 ; Ŀ
 ;   While there are entities, check them.                                 
 ; 
  (setq sub 0)
  (setq kills 0)
  (setq num 0)
  (setq enam (entnext))
  (while enam
         (grtext -2 (itoa (setq num (1+ num))))
         (setq entt (entget enam))
         (setq ten (cdr (assoc 10 entt)))
         (cond ((assoc 66 entt)
                (setq inner t))
               ((= (cdr (assoc 0 entt)) "SEQEND")
                (setq inner ())))
         (if (equal pa ten fuzz)
             (progn
                  (print entt)
                  (mark ten rad 1)
                  (if inner (setq sub (1+ sub)))
                  (cond ((and kill inner)
                         (setq kills (1+ kills))
                         (entdel (headup enam)))
                        (kill
                         (setq kills (1+ kills))
                         (entdel enam))
                        (inner
                         (ssadd (headup enam) ss))
                        (t (ssadd enam ss)))))
         (setq enam (entnext enam)))
  (if (null kill)
      (write-line (strcat "\n" (itoa (setq len (sslength ss))) " Entit"
                          (if (= len 1) "y" "ies") "/"
                          (itoa sub) " Subentit"
                          (if (= sub 1) "y" "ies") " found."))
      (write-line (strcat "\n" (itoa kills) " Entit"
                          (if (= kills 1) "y" "ies") " erased.")))
  (command "select" ss "")
 (princ))
